namespace Najblizi_Neprijatelj
{
    internal class Program
    {
        public static void UnosPodataka(out int n, out string rasporedNaKruznomToku)
        {
            n = int.Parse(Console.ReadLine());
            rasporedNaKruznomToku = Console.ReadLine();
        }

        public static int PozicijaSocka(int n, string rasporedNaKruznomToku)
        {
            for(int i = 0; i < n; i++)
            {
                if (rasporedNaKruznomToku[i] == '+') return i;
            }

            return -1;
        }

        public static int NajbliziNeprijatelj(int n, string rasporedNaKruznomToku, int pozicijaSocka)
        {
            // Inicijalizujemo minimalnu udaljenost na maksimalnu mogucu vrednost
            int minUdaljenost = int.MaxValue;

            // Trazanje najblizeg neprijatelja
            for (int i = 0; i < n; i++)
            {
                if (rasporedNaKruznomToku[i] == '#')
                {
                    int udaljenost = Math.Abs(pozicijaSocka - i);
                    minUdaljenost = Math.Min(minUdaljenost, Math.Min(udaljenost, n - udaljenost));
                }
            }

            return minUdaljenost;
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out string rasporedNaKruznomToku);

            // Pronalaženje pozicije Socka
            int pozicijaSocka = PozicijaSocka(n, rasporedNaKruznomToku);

            // Pronalaženje najbližeg neprijatelja
            Console.WriteLine(NajbliziNeprijatelj(n, rasporedNaKruznomToku, pozicijaSocka));

        }
    }
}